import React, { useState } from "react";
import "./styles.css";
import App from "../App/App";

function LoginButton() {
  // React States
  const [errorMessages, setErrorMessages] = useState({});
  const [isSubmitted, setIsSubmitted] = useState(false);
  const [Usuario, setUsuario] = useState('');
  
  // Ahora se consulta la API en: http://localhost:3000/api/usuarios/{id}
  // El endpoint debe devolver JSON con { username, password, ... }
 

  const errors = {
    usuario: "Usuario Incorrecto",
    contrasena: "Contrasena Incorrecta"
  };

  const handleSubmit = async (event) => {
    event.preventDefault();
    const { usuario, contrasena } = document.forms[0];
    console.log(usuario.value);
    console.log(contrasena.value);
    try {
      const res = await fetch(`http://localhost:3000/api/usuarios/login/`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          usuario: usuario.value,
          contrasena: contrasena.value
        })
      });

      if (!res.ok) {
        if (res.status === 404) {
          setErrorMessages({ name: "usuario", message: errors.usuario });
        } else {
          setErrorMessages({ name: "usuario", message: "Error del servidor" });
        }
        return;
      }

      const userData = await res.json();

      if (userData && userData.contrasena === contrasena.value) {
        // backend stores the field as `usuario` not `username`
        setUsuario(userData.usuario || userData.username || usuario.value);
        setIsSubmitted(true);
      } else if (userData) {
        setErrorMessages({ name: "contrasena", message: errors.contrasena });
      } else {
        setErrorMessages({ name: "usuario", message: errors.usuario });
      }
    } catch (error) {
      setErrorMessages({ name: "usuario", message: "No se puede iniciar sesión - Contactar con el Administrador" });
      console.error(error);
    }
  };

  // Generate JSX code for error message
  const renderErrorMessage = (name) =>
    name === errorMessages.name && (
      <div className="error">{errorMessages.message}</div>
    );

  const handleLogoutFromApp = () => {
    setIsSubmitted(false);
    setUsuario('');
    setErrorMessages({});
  };

    
  // JSX code for login form
  const renderForm = (
    <div> 
      <div className='App'>
        <p className='App-intro'></p>
      </div>
      <div className="app">
        <div className="login-card">
          
          <div className="login-content">
            <div className="login-image">
       

              <img alt="GAD  de la Parroquia Sayausi" src="https://res.cloudinary.com/curso-node-jism/image/upload/v1661789319/sayausi/logo_qh6nxj.jpg" />
            </div>

            <form className="form login-form" onSubmit={handleSubmit} noValidate>
              <div className="field">
                <input type="text" name="usuario" placeholder="Usuario" required />
              </div>

              <div className="field">
                <input type="password" name="contrasena" placeholder="Contraseña" required />
              </div>

              <div className="actions">
                <button className="btn" type="submit">Ingresar</button>
              </div>
              <div align="center">
                    {renderErrorMessage("usuario")}
                    {renderErrorMessage("contrasena")}
              </div>
                                        
            </form>
          </div>

          <footer className="login-footer">
            <div className="footer-title">Sistema de Administración del Cementerio</div>
            <div className="footer-copy">© {new Date().getFullYear()} PC Web Soluciones</div>
          </footer>

        </div>
      </div>
    </div>
  );

  // callback para pasar a App y permitir que vuelva al formulario sin recargar


  return (
    isSubmitted ? <App name={Usuario} onLogout={handleLogoutFromApp} /> : renderForm
  );
}

export default LoginButton;