import React, { Component } from 'react';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { Button, Icon } from "semantic-ui-react";

export default class ExcelExport extends Component  {
  
  exportToExcel = () => {
    
    const worksheet = XLSX.utils.json_to_sheet(this.props.data);
    const workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');
    const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
    const blob = new Blob([excelBuffer], {type: 'application/octet-stream'});
    saveAs(blob, `${this.props.fileName}.xlsx`);
  };
  render() {
		return (
    <Button color='blue' icon onClick={this.exportToExcel}><Icon name='database' ></Icon> Exportar a Excel</Button> 
  )  
}
}