"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

exports.__esModule = true;
exports.RefForward = void 0;

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

var React = _interopRequireWildcard(require("react"));

var _utils = require("./utils");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var RefForward = /*#__PURE__*/function (_React$Component) {
  (0, _inheritsLoose2.default)(RefForward, _React$Component);

  function RefForward() {
    var _this;

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;
    _this.currentNode = void 0;

    _this.handleRefOverride = function (node) {
      var _this$props = _this.props,
          children = _this$props.children,
          innerRef = _this$props.innerRef;
      (0, _utils.handleRef)(children.ref, node);
      (0, _utils.handleRef)(innerRef, node);
      _this.currentNode = node;
    };

    return _this;
  }

  var _proto = RefForward.prototype;

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    if (prevProps.innerRef !== this.props.innerRef) {
      (0, _utils.handleRef)(this.props.innerRef, this.currentNode);
    }
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    delete this.currentNode;
  };

  _proto.render = function render() {
    var children = this.props.children;
    return /*#__PURE__*/React.cloneElement(children, {
      ref: this.handleRefOverride
    });
  };

  return RefForward;
}(React.Component);

exports.RefForward = RefForward;
//# sourceMappingURL=RefForward.js.map
