"use strict";

exports.__esModule = true;
exports.useEventListener = void 0;

var React = _interopRequireWildcard(require("react"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var getWindowEvent = function getWindowEvent(target) {
  if (target) {
    var _ownerDocument$defaul, _ownerDocument, _ownerDocument$defaul2;

    if (typeof target.window === 'object' && target.window === target) {
      return target.event;
    }

    return (_ownerDocument$defaul = (_ownerDocument = target.ownerDocument) == null ? void 0 : (_ownerDocument$defaul2 = _ownerDocument.defaultView) == null ? void 0 : _ownerDocument$defaul2.event) != null ? _ownerDocument$defaul : undefined;
  }

  return undefined;
};

var isActionSupported = function isActionSupported(element, method) {
  return element ? !!element[method] : false;
};

var useEventListener = function useEventListener(options) {
  var capture = options.capture,
      listener = options.listener,
      type = options.type,
      target = options.target,
      targetRef = options.targetRef;
  var latestListener = React.useRef(listener);
  latestListener.current = listener;
  var eventHandler = React.useCallback(function (event) {
    return latestListener.current(event);
  }, []);
  var timeoutId = React.useRef(undefined);

  if (process.env.NODE_ENV !== 'production') {
    // This is fine to violate there conditional rule as environment variables will never change during component
    // lifecycle
    // eslint-disable-next-line react-hooks/rules-of-hooks
    React.useEffect(function () {
      if (typeof target !== 'undefined' && typeof targetRef !== 'undefined') {
        throw new Error('`target` and `targetRef` props are mutually exclusive, please use one of them.');
      }

      if (typeof target === 'undefined' && typeof targetRef === 'undefined') {
        throw new Error("`target` and `targetRef` props are `undefined`, it' required to use one of them.");
      }
    }, [target, targetRef]);
  }

  React.useEffect(function () {
    var element = typeof targetRef === 'undefined' ? target : targetRef.current; // Store the current event to avoid triggering handlers immediately
    // Note this depends on a deprecated but extremely well supported quirk of the web platform
    // https://github.com/facebook/react/issues/20074

    var currentEvent = getWindowEvent(window);

    var conditionalHandler = function conditionalHandler(event) {
      // Skip if this event is the same as the one running when we added the handlers
      if (event === currentEvent) {
        currentEvent = undefined;
        return;
      }

      eventHandler(event);
    };

    if (isActionSupported(element, 'addEventListener')) {
      element.addEventListener(type, conditionalHandler, capture);
    } else if (process.env.NODE_ENV !== 'production') {
      throw new Error('@fluentui/react-component-event-listener: Passed `element` is not valid or does not support `addEventListener()` method.');
    } // @ts-ignore We have a collision between types from DOM and @types/node


    timeoutId.current = setTimeout(function () {
      currentEvent = undefined;
    }, 1);
    return function () {
      clearTimeout(timeoutId.current);
      currentEvent = undefined;

      if (isActionSupported(element, 'removeEventListener')) {
        element.removeEventListener(type, conditionalHandler, capture);
      } else if (process.env.NODE_ENV !== 'production') {
        throw new Error('@fluentui/react-component-event-listener: Passed `element` is not valid or does not support `removeEventListener()` method.');
      }
    };
  }, [capture, eventHandler, target, targetRef, type]);
};

exports.useEventListener = useEventListener;
//# sourceMappingURL=useEventListener.js.map
